require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- #Author Directives Go Here# --
-- #End Author Directives# --

cartNailseaWander = Wherigo.ZCartridge()

-- MessageBox Callback Functions Table used by the Builder --
cartNailseaWander.MsgBoxCBFuncs = {}

zmediaQuestion = Wherigo.ZMedia(cartNailseaWander)
zmediaQuestion.Name="Question"
zmediaQuestion.Description=""
zmediaQuestion.AltText=""
zmediaQuestion.Id="37cb3cc2-6b2e-42a5-a9db-4d82799abc4a"
zmediaQuestion.Resources = {
{ Type = "jpg", Filename = "question.jpg", Directives = {},},
}
zmediaIncorrect = Wherigo.ZMedia(cartNailseaWander)
zmediaIncorrect.Name="Incorrect!"
zmediaIncorrect.Description=""
zmediaIncorrect.AltText=""
zmediaIncorrect.Id="6d8d21ef-dc6d-44a3-ade8-be29aa7e4bac"
zmediaIncorrect.Resources = {
{ Type = "jpg", Filename = "sad_smiley.jpg", Directives = {},},
}
zmediaCorrect = Wherigo.ZMedia(cartNailseaWander)
zmediaCorrect.Name="Correct!"
zmediaCorrect.Description=""
zmediaCorrect.AltText=""
zmediaCorrect.Id="a5b6a019-362a-4a2b-812d-45ebe316a7b0"
zmediaCorrect.Resources = {
{ Type = "jpg", Filename = "smiley.jpg", Directives = {},},
}
zmediaCadburyCamp = Wherigo.ZMedia(cartNailseaWander)
zmediaCadburyCamp.Name="Cadbury Camp"
zmediaCadburyCamp.Description=""
zmediaCadburyCamp.AltText=""
zmediaCadburyCamp.Id="0b6dd655-0bbe-4b96-8c49-91aef6b43313"
zmediaCadburyCamp.Resources = {
{ Type = "jpg", Filename = "Cadbury Camp.jpg", Directives = {},},
}
zmediaTickenhamChurch = Wherigo.ZMedia(cartNailseaWander)
zmediaTickenhamChurch.Name="Tickenham Church"
zmediaTickenhamChurch.Description=""
zmediaTickenhamChurch.AltText=""
zmediaTickenhamChurch.Id="338d03c7-b03f-4e61-a882-b4fd270d3195"
zmediaTickenhamChurch.Resources = {
{ Type = "jpg", Filename = "tickenham by night.jpg", Directives = {},},
}
zmediaNoahsArk = Wherigo.ZMedia(cartNailseaWander)
zmediaNoahsArk.Name="Noah's Ark"
zmediaNoahsArk.Description="Second oldest house in Nailsea"
zmediaNoahsArk.AltText=""
zmediaNoahsArk.Id="b88957b7-030c-4c8e-9bde-9990e3855cdc"
zmediaNoahsArk.Resources = {
{ Type = "jpg", Filename = "noahsark.jpg", Directives = {},},
}
zmediaStatue = Wherigo.ZMedia(cartNailseaWander)
zmediaStatue.Name="Statue"
zmediaStatue.Description=""
zmediaStatue.AltText=""
zmediaStatue.Id="6d7c8039-6979-4a07-980a-bb1f66a72ebf"
zmediaStatue.Resources = {
{ Type = "jpg", Filename = "statue.jpg", Directives = {},},
}
zmediaclapping = Wherigo.ZMedia(cartNailseaWander)
zmediaclapping.Name="clapping"
zmediaclapping.Description="for correct answers"
zmediaclapping.AltText=""
zmediaclapping.Id="10969e92-d641-4dbf-8d41-85170cc0cbd2"
zmediaclapping.Resources = {
{ Type = "wav", Filename = "applause3.wav", Directives = {},},
}
zmediascream = Wherigo.ZMedia(cartNailseaWander)
zmediascream.Name="scream"
zmediascream.Description="female scream for the wrong answer"
zmediascream.AltText=""
zmediascream.Id="fe4baaff-016c-4b6e-9c5f-09a0b703f9bd"
zmediascream.Resources = {
{ Type = "wav", Filename = "scream_females.wav", Directives = {},},
}
zmediaFanfare = Wherigo.ZMedia(cartNailseaWander)
zmediaFanfare.Name="Fanfare"
zmediaFanfare.Description="for completing the cache"
zmediaFanfare.AltText=""
zmediaFanfare.Id="f248ac8e-c8e2-4b46-b644-08edcc15d7b7"
zmediaFanfare.Resources = {
{ Type = "wav", Filename = "fanfare3.wav", Directives = {},},
}
zmediacampsign = Wherigo.ZMedia(cartNailseaWander)
zmediacampsign.Name="camp sign"
zmediacampsign.Description=""
zmediacampsign.AltText=""
zmediacampsign.Id="3fb160ad-f99d-4a0f-8882-c64a98d69753"
zmediacampsign.Resources = {
{ Type = "jpg", Filename = "campsign.jpg", Directives = {},},
}
zmediachurchgrave = Wherigo.ZMedia(cartNailseaWander)
zmediachurchgrave.Name="church grave"
zmediachurchgrave.Description=""
zmediachurchgrave.AltText=""
zmediachurchgrave.Id="b43019b1-7ad2-417c-8f54-22f7a001c2df"
zmediachurchgrave.Resources = {
{ Type = "jpg", Filename = "grave.jpg", Directives = {},},
}
zmediaintro = Wherigo.ZMedia(cartNailseaWander)
zmediaintro.Name="intro"
zmediaintro.Description=""
zmediaintro.AltText=""
zmediaintro.Id="dfa78ce4-ada6-46c5-b2e8-38bed85d2abb"
zmediaintro.Resources = {
{ Type = "jpg", Filename = "intro1.jpg", Directives = {},},
}
zmediaintro2 = Wherigo.ZMedia(cartNailseaWander)
zmediaintro2.Name="intro2"
zmediaintro2.Description=""
zmediaintro2.AltText=""
zmediaintro2.Id="6ce7eebb-f8b0-4230-bc94-766a485276c5"
zmediaintro2.Resources = {
{ Type = "jpg", Filename = "intro2.jpg", Directives = {},},
}
zmediawherigologo = Wherigo.ZMedia(cartNailseaWander)
zmediawherigologo.Name="wherigo logo"
zmediawherigologo.Description=""
zmediawherigologo.AltText=""
zmediawherigologo.Id="f9bb7f02-5c3b-4b64-bc76-840ee759cde8"
zmediawherigologo.Resources = {
{ Type = "jpg", Filename = "wgologo-3D-sm.jpg", Directives = {},},
}
zmediajacklands = Wherigo.ZMedia(cartNailseaWander)
zmediajacklands.Name="jacklands"
zmediajacklands.Description=""
zmediajacklands.AltText=""
zmediajacklands.Id="5c6f390c-85a1-4592-b902-f6b0c46bb248"
zmediajacklands.Resources = {
{ Type = "jpg", Filename = "fishfarm.jpg", Directives = {},},
}
zmediaTheCache = Wherigo.ZMedia(cartNailseaWander)
zmediaTheCache.Name="The Cache"
zmediaTheCache.Description=""
zmediaTheCache.AltText=""
zmediaTheCache.Id="4da58c8d-0b88-412f-aa4a-523e0c36bd0b"
zmediaTheCache.Resources = {
{ Type = "jpg", Filename = "cache.jpg", Directives = {},},
}
zmediafrontpage = Wherigo.ZMedia(cartNailseaWander)
zmediafrontpage.Name="front page"
zmediafrontpage.Description=""
zmediafrontpage.AltText=""
zmediafrontpage.Id="84797adf-c9b0-4ca4-a021-897c8d65fa8c"
zmediafrontpage.Resources = {
{ Type = "jpg", Filename = "moors dyke copy.jpg", Directives = {},},
}
-- Cartridge Info --
cartNailseaWander.Id="b4068d0c-dd4a-427a-9918-7238c9ed2dc5"
cartNailseaWander.Name="Nailsea Wander"
cartNailseaWander.Description=[[This is a nice wander round a few sites in Nailsea. Answer a simple question at each to move to the next stage, which will only become visible when you have the correct data.


You should plan for a walk of some 2 hours to complete the cartridge.


There is a physical cache at the conclusion of the trail but you may only log the cache on completion of the cartidge and unlocking the code.

The Starting Location is a free car park well placed for this wander.....Good Luck]]
cartNailseaWander.Visible=true
cartNailseaWander.Activity="Puzzle"
cartNailseaWander.StartingLocationDescription=[[Free Car Park]]
cartNailseaWander.StartingLocation = ZonePoint(51.4345499992371,-2.75216668446859,0)
cartNailseaWander.Version="1.1"
cartNailseaWander.Company="caching corporation"
cartNailseaWander.Author="corporal gore-tex"
cartNailseaWander.BuilderVersion="2.0.4907.3996"
cartNailseaWander.CreateDate="1/3/2008 9:55:33 PM"
cartNailseaWander.PublishDate="3/8/2008 5:41:17 PM"
cartNailseaWander.UpdateDate="3/22/2008 8:38:27 PM"
cartNailseaWander.LastPlayedDate="1/1/0001 12:00:00 AM"
cartNailseaWander.TargetDevice="PocketPC"
cartNailseaWander.TargetDeviceVersion="0"
cartNailseaWander.StateId="1"
cartNailseaWander.CountryId="2"
cartNailseaWander.Complete=false
cartNailseaWander.UseLogging=false
cartNailseaWander.Media=zmediafrontpage
cartNailseaWander.Icon=zmediawherigologo

-- Zones --
zoneNoahsArk = Wherigo.Zone(cartNailseaWander)
zoneNoahsArk.Id="363bf68b-938b-418f-9981-2fba9c67e444"
zoneNoahsArk.Name="Noah's Ark"
zoneNoahsArk.Description=[[Does what it says on the tin, start here at Nailsea's second oldest house. It has been a pub, four glassblowers cottages and was purchased in 1656 for sixty eight pounds including some 9 acres of land.


The item you seek was placed by the then owner under the rule of King Charles II who is reported to have visited the house.

]]
zoneNoahsArk.Visible=true
zoneNoahsArk.DistanceRange = Distance(-1, "meters")
zoneNoahsArk.ShowObjects="OnEnter"
zoneNoahsArk.ProximityRange = Distance(50, "meters")
zoneNoahsArk.AllowSetPositionTo=false
zoneNoahsArk.Active=true
zoneNoahsArk.Points = {
  ZonePoint(51.43185,-2.75491,0),
  ZonePoint(51.43185,-2.75459,0),
  ZonePoint(51.43165,-2.75459,0),
  ZonePoint(51.43165,-2.75491,0)
}
zoneNoahsArk.OriginalPoint = ZonePoint(51.4317500114441,-2.75474999745687,0)
zoneNoahsArk.DistanceRangeUOM = "Meters"
zoneNoahsArk.ProximityRangeUOM = "Meters"
zoneNoahsArk.OutOfRangeName = ""
zoneNoahsArk.InRangeName = ""
zoneNoahsArk.Media=zmediaNoahsArk

zoneJacklandsFishFarm = Wherigo.Zone(cartNailseaWander)
zoneJacklandsFishFarm.Id="e8d6620f-104d-4ade-ba57-dc99374a25ba"
zoneJacklandsFishFarm.Name="Jacklands Fish Farm"
zoneJacklandsFishFarm.Description=[[Is this the smallest fly fishing venue in Somerset? I think so.]]
zoneJacklandsFishFarm.Visible=false
zoneJacklandsFishFarm.DistanceRange = Distance(-1, "meters")
zoneJacklandsFishFarm.ShowObjects="OnEnter"
zoneJacklandsFishFarm.ProximityRange = Distance(50, "meters")
zoneJacklandsFishFarm.AllowSetPositionTo=false
zoneJacklandsFishFarm.Active=false
zoneJacklandsFishFarm.Points = {
  ZonePoint(51.4418,-2.76249,0),
  ZonePoint(51.4418,-2.76234,0),
  ZonePoint(51.4417,-2.76234,0),
  ZonePoint(51.4417,-2.76249,0)
}
zoneJacklandsFishFarm.OriginalPoint = ZonePoint(51.4417499860128,-2.76241664886475,0)
zoneJacklandsFishFarm.DistanceRangeUOM = "Meters"
zoneJacklandsFishFarm.ProximityRangeUOM = "Meters"
zoneJacklandsFishFarm.OutOfRangeName = ""
zoneJacklandsFishFarm.InRangeName = ""
zoneJacklandsFishFarm.Media=zmediajacklands

zoneCadburyCamp = Wherigo.Zone(cartNailseaWander)
zoneCadburyCamp.Id="1a06160c-2bd7-4959-a0f8-e8909ea9de2e"
zoneCadburyCamp.Name="Cadbury Camp"
zoneCadburyCamp.Description=[[Cadbury Camp is an Iron Age hill fort near the village of Tickenham. Local legends associate it with Arthurian England and Camelot, though these may be due to confusion with the better-known Cadbury Castle, near South Cadbury some 50 miles to the south. The hill fort is well preserved, and is managed by the National Trust.

]]
zoneCadburyCamp.Visible=false
zoneCadburyCamp.DistanceRange = Distance(-1, "meters")
zoneCadburyCamp.ShowObjects="OnEnter"
zoneCadburyCamp.ProximityRange = Distance(50, "meters")
zoneCadburyCamp.AllowSetPositionTo=false
zoneCadburyCamp.Active=false
zoneCadburyCamp.Points = {
  ZonePoint(51.44981,-2.78689,0),
  ZonePoint(51.44981,-2.78671,0),
  ZonePoint(51.44969,-2.78671,0),
  ZonePoint(51.44969,-2.78689,0)
}
zoneCadburyCamp.OriginalPoint = ZonePoint(51.4497500101725,-2.78680000305176,0)
zoneCadburyCamp.DistanceRangeUOM = "Meters"
zoneCadburyCamp.ProximityRangeUOM = "Meters"
zoneCadburyCamp.OutOfRangeName = ""
zoneCadburyCamp.InRangeName = ""
zoneCadburyCamp.Media=zmediaCadburyCamp

zoneTickenhamChurch = Wherigo.Zone(cartNailseaWander)
zoneTickenhamChurch.Id="558dcea6-84ce-4235-a87e-c8a2d82b5bbd"
zoneTickenhamChurch.Name="Tickenham Church"
zoneTickenhamChurch.Description=[[The parish church of Tickenham has the unusual dedication of St. Quiricus & St Julietta. Julietta was a widow travelling with her three year old son in the year 304 AD when, in Tarsus, she was recognised as a Christian and arrested and taken before the Governor Alexander and invited to recant. This she refused to do and was being tortured for her beliefs while her small son Quiricus was held on the knee of Alexander. He, Quiricus, however attempted to get to his mother and in his struggles scratched the face of the Governor. This angered the Governor and caused him to throw young Quiricus down onto the steps of his tribune which smashed the boys skull and killed him. Thereupon, Julietta thanked God for granting martyrdom to her son. A statue depicting the martyrdom of Quiricus is to be seen in the south parapet of the church tower. On the eastern parapet of the tower is a statue showing Julietta holding a sword which is said to be the instrument which finally killed her.]]
zoneTickenhamChurch.Visible=false
zoneTickenhamChurch.DistanceRange = Distance(-1, "meters")
zoneTickenhamChurch.ShowObjects="OnEnter"
zoneTickenhamChurch.ProximityRange = Distance(50, "meters")
zoneTickenhamChurch.AllowSetPositionTo=false
zoneTickenhamChurch.Active=false
zoneTickenhamChurch.Points = {
  ZonePoint(51.43936,-2.78166,0),
  ZonePoint(51.43936,-2.78147,0),
  ZonePoint(51.43924,-2.78147,0),
  ZonePoint(51.43924,-2.78166,0)
}
zoneTickenhamChurch.OriginalPoint = ZonePoint(51.4392999966939,-2.78156668345133,0)
zoneTickenhamChurch.DistanceRangeUOM = "Meters"
zoneTickenhamChurch.ProximityRangeUOM = "Meters"
zoneTickenhamChurch.OutOfRangeName = ""
zoneTickenhamChurch.InRangeName = ""
zoneTickenhamChurch.Media=zmediaTickenhamChurch

zoneTheCache = Wherigo.Zone(cartNailseaWander)
zoneTheCache.Id="5652bc08-e48e-4ecb-94c8-3b37d80137ff"
zoneTheCache.Name="The Cache"
zoneTheCache.Description=[[Your final goal is very near!]]
zoneTheCache.Visible=false
zoneTheCache.DistanceRange = Distance(-1, "feet")
zoneTheCache.ShowObjects="OnEnter"
zoneTheCache.ProximityRange = Distance(50, "meters")
zoneTheCache.AllowSetPositionTo=false
zoneTheCache.Active=false
zoneTheCache.Points = {
  ZonePoint(51.43296,-2.78728,0),
  ZonePoint(51.43296,-2.78719,0),
  ZonePoint(51.4329,-2.78719,0),
  ZonePoint(51.4329,-2.78728,0)
}
zoneTheCache.OriginalPoint = ZonePoint(51.4329333305359,-2.78723335266113,0)
zoneTheCache.DistanceRangeUOM = "Feet"
zoneTheCache.ProximityRangeUOM = "Meters"
zoneTheCache.OutOfRangeName = ""
zoneTheCache.InRangeName = ""
zoneTheCache.Media=zmediaTheCache

zoneNailseaLocalFigure = Wherigo.Zone(cartNailseaWander)
zoneNailseaLocalFigure.Id="531d14ae-8c70-42ea-9832-8806c9a96ae4"
zoneNailseaLocalFigure.Name="Nailsea Local Figure"
zoneNailseaLocalFigure.Description=[[A Bronze statue marking Nailsea's glass-making history has been unveiled at a special ceremony.The statue, which was designed by Barnstaple-based artist Vanessa Marston, cost 30,000 to create and was funded jointly by Nailsea Town Council and money handed over as part of a legal deal to ensure planning permission for the town's Tesco store.

The idea to create a bronze of a glassblower came after councillors decided they wanted to create a permanent reminder of the town's former prominent industry.

The Nailsea Glassworks was in operation from 1788 until 1873.
]]
zoneNailseaLocalFigure.Visible=false
zoneNailseaLocalFigure.DistanceRange = Distance(-1, "meters")
zoneNailseaLocalFigure.ShowObjects="OnEnter"
zoneNailseaLocalFigure.ProximityRange = Distance(50, "meters")
zoneNailseaLocalFigure.AllowSetPositionTo=false
zoneNailseaLocalFigure.Active=false
zoneNailseaLocalFigure.Points = {
  ZonePoint(51.43478,-2.75391,0),
  ZonePoint(51.43478,-2.75376,0),
  ZonePoint(51.43468,-2.75376,0),
  ZonePoint(51.43468,-2.75391,0)
}
zoneNailseaLocalFigure.OriginalPoint = ZonePoint(51.4347333272298,-2.75383332570394,0)
zoneNailseaLocalFigure.DistanceRangeUOM = "Meters"
zoneNailseaLocalFigure.ProximityRangeUOM = "Meters"
zoneNailseaLocalFigure.OutOfRangeName = ""
zoneNailseaLocalFigure.InRangeName = ""
zoneNailseaLocalFigure.Media=zmediaStatue

-- Characters --

-- Items --

-- Tasks --
ztaskGotoNoahsArk = Wherigo.ZTask(cartNailseaWander)
ztaskGotoNoahsArk.Id="e69f99e2-c7b2-4a1e-8934-8236c39d7304"
ztaskGotoNoahsArk.Name="Go to Noah's Ark"
ztaskGotoNoahsArk.Description=[[]]
ztaskGotoNoahsArk.Visible=true
ztaskGotoNoahsArk.Active=true
ztaskGotoNoahsArk.Complete=false
ztaskGotoNoahsArk.CorrectState = "None"

ztaskGotoStatue = Wherigo.ZTask(cartNailseaWander)
ztaskGotoStatue.Id="1a470e03-9904-4e42-861a-e809513fd1c1"
ztaskGotoStatue.Name="Go to Statue"
ztaskGotoStatue.Description=[[]]
ztaskGotoStatue.Visible=true
ztaskGotoStatue.Active=false
ztaskGotoStatue.Complete=false
ztaskGotoStatue.CorrectState = "None"

ztaskGotoFishFarm = Wherigo.ZTask(cartNailseaWander)
ztaskGotoFishFarm.Id="66be7426-aff0-4fe5-ba4d-790b31ac4ccc"
ztaskGotoFishFarm.Name="Go to Fish Farm"
ztaskGotoFishFarm.Description=[[]]
ztaskGotoFishFarm.Visible=true
ztaskGotoFishFarm.Active=false
ztaskGotoFishFarm.Complete=false
ztaskGotoFishFarm.CorrectState = "None"

ztaskGotothecamp = Wherigo.ZTask(cartNailseaWander)
ztaskGotothecamp.Id="624de308-49d5-4497-82d8-883b04d6361f"
ztaskGotothecamp.Name="Go to the camp"
ztaskGotothecamp.Description=[[]]
ztaskGotothecamp.Visible=true
ztaskGotothecamp.Active=false
ztaskGotothecamp.Complete=false
ztaskGotothecamp.CorrectState = "None"

ztaskGotothecache = Wherigo.ZTask(cartNailseaWander)
ztaskGotothecache.Id="e40b2390-0dff-4d11-97c0-876ad835a782"
ztaskGotothecache.Name="Go to the cache!"
ztaskGotothecache.Description=[[]]
ztaskGotothecache.Visible=true
ztaskGotothecache.Active=false
ztaskGotothecache.Complete=false
ztaskGotothecache.CorrectState = "None"

ztaskGotothechurch = Wherigo.ZTask(cartNailseaWander)
ztaskGotothechurch.Id="df3fa651-68b6-4d93-9b6e-d2530ba4048c"
ztaskGotothechurch.Name="Go to the church"
ztaskGotothechurch.Description=[[]]
ztaskGotothechurch.Visible=true
ztaskGotothechurch.Active=false
ztaskGotothechurch.Complete=false
ztaskGotothechurch.CorrectState = "None"

-- Cartridge Variables --
House = ""
ccode = ""
Camp = ""
Statue = ""
Church = ""
Trout = ""
cartNailseaWander.ZVariables = {House = "", ccode = "", Camp = "", Statue = "", Church = "", Trout = ""}

-- Builder Variables (to be read by the builder only) --
buildervar = {}
buildervar.House = {}
buildervar.House.Id ="e6a17711-4b87-4fe4-a457-96e23701b7a5"
buildervar.House.Name = "House"
buildervar.House.Type = "String"
buildervar.House.Data=[[]]
buildervar.House.Description=[[date of Noah's Ark]]

buildervar.ccode = {}
buildervar.ccode.Id ="36de8389-012a-4623-83ed-8f94ea69dca2"
buildervar.ccode.Name = "ccode"
buildervar.ccode.Type = "String"
buildervar.ccode.Data=[[]]
buildervar.ccode.Description=[[cache completion code]]

buildervar.Camp = {}
buildervar.Camp.Id ="ea7e620e-1018-469f-8a8b-d13d1760688b"
buildervar.Camp.Name = "Camp"
buildervar.Camp.Type = "String"
buildervar.Camp.Data=[[]]
buildervar.Camp.Description=[[postcode]]

buildervar.Statue = {}
buildervar.Statue.Id ="c4e347ba-9fca-4a67-b8ba-82cd2e74db35"
buildervar.Statue.Name = "Statue"
buildervar.Statue.Type = "String"
buildervar.Statue.Data=[[]]
buildervar.Statue.Description=[[date statue was erected added up]]

buildervar.Church = {}
buildervar.Church.Id ="49e02f48-33af-4ede-b570-9507a7272e5a"
buildervar.Church.Name = "Church"
buildervar.Church.Type = "String"
buildervar.Church.Data=[[]]
buildervar.Church.Description=[[age on resting]]

buildervar.Trout = {}
buildervar.Trout.Id ="77a8acf8-eb0d-418c-b8e2-4005991c332c"
buildervar.Trout.Name = "Trout"
buildervar.Trout.Type = "String"
buildervar.Trout.Data=[[]]
buildervar.Trout.Description=[[number on the gate]]


-- ZTimers --

-- Inputs --
zinputHouse = Wherigo.ZInput(cartNailseaWander)
zinputHouse.Id="2fbf6bd0-9693-49bf-8c0e-40629f0d9f1b"
zinputHouse.Name="House"
zinputHouse.Description=[[Noah's Ark]]
zinputHouse.Visible=true
zinputHouse.InputType="Text"
zinputHouse.InputVariableId="e6a17711-4b87-4fe4-a457-96e23701b7a5"
zinputHouse.Text=[[What is the date above the front doors of this house]]
zinputHouse.Media=zmediaQuestion

zinputStatue = Wherigo.ZInput(cartNailseaWander)
zinputStatue.Id="57801f9e-e805-40ac-93e4-3d8d2acd7aa3"
zinputStatue.Name="Statue"
zinputStatue.Description=[[Nailsea Glassworks area]]
zinputStatue.Visible=true
zinputStatue.InputType="Text"
zinputStatue.InputVariableId="c4e347ba-9fca-4a67-b8ba-82cd2e74db35"
zinputStatue.Text=[[This new statue has a date plaque on it. What is the sum of all the visible numbers on the plaque?]]
zinputStatue.Media=zmediaStatue

zinputfishyquestion = Wherigo.ZInput(cartNailseaWander)
zinputfishyquestion.Id="14375737-fba1-41aa-a2cc-beb77aff972f"
zinputfishyquestion.Name="fishy question"
zinputfishyquestion.Description=[[]]
zinputfishyquestion.Visible=true
zinputfishyquestion.InputType="Text"
zinputfishyquestion.InputVariableId="77a8acf8-eb0d-418c-b8e2-4005991c332c"
zinputfishyquestion.Text=[[You are now at a fly fishing venue. Find the disc on the sleeper, convert the letter to a number (A=1, B=2 etc) and add the other numbers and type in the answer]]
zinputfishyquestion.Media=zmediaQuestion

zinputcamp = Wherigo.ZInput(cartNailseaWander)
zinputcamp.Id="bbce047b-31fa-431e-88f3-dda072250a58"
zinputcamp.Name="camp"
zinputcamp.Description=[[answer to cadbury camp question]]
zinputcamp.Visible=true
zinputcamp.InputType="Text"
zinputcamp.InputVariableId="ea7e620e-1018-469f-8a8b-d13d1760688b"
zinputcamp.Text=[[After wandering round the camp find the notice board by the gate. Enter the post code on the sign in CAPITAL letters.]]
zinputcamp.Media=zmediacampsign

zinputchurch = Wherigo.ZInput(cartNailseaWander)
zinputchurch.Id="db5ce461-a866-444e-b831-6b273f17f74d"
zinputchurch.Name="church"
zinputchurch.Description=[[church question]]
zinputchurch.Visible=true
zinputchurch.InputType="Text"
zinputchurch.InputVariableId="49e02f48-33af-4ede-b570-9507a7272e5a"
zinputchurch.Text=[[Find the pictures feature and input the age of resting]]
zinputchurch.Media=zmediachurchgrave

zinputcompletioncode = Wherigo.ZInput(cartNailseaWander)
zinputcompletioncode.Id="b679da30-7e47-4af5-a7cd-a8c526b25b24"
zinputcompletioncode.Name="completion code"
zinputcompletioncode.Description=[[]]
zinputcompletioncode.Visible=true
zinputcompletioncode.InputType="Text"
zinputcompletioncode.InputVariableId="36de8389-012a-4623-83ed-8f94ea69dca2"
zinputcompletioncode.Text=[[Enter the completion code word answer from the inside cover of the log book]]
zinputcompletioncode.Media=zmediawherigologo

--
-- Events/Conditions/Actions --
--

-------------------------------------------------------------------------------
------Builder Generated functions, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------

function zinputHouse:OnGetInput(input)
House = concathex(input)
-- #GroupDescription=house answer --
-- #Comment=house answer Comment --
if   Wherigo.NoCaseEquals(House,"31363636") then
Wherigo.MessageBox{Text=[[That is correct! Now make your way to the next zone.]],Media=zmediaCorrect,}
Wherigo.PlayAudio(zmediaclapping)
zoneNoahsArk.Visible = false
zoneNailseaLocalFigure.Visible = true
zoneNailseaLocalFigure.Active = true
else
Wherigo.PlayAudio(zmediascream)
Wherigo.MessageBox{Text=[[No, rubbish, try again.]],Media=zmediaIncorrect,}
end
end

function zoneNoahsArk:OnEnter()
-- #GroupDescription=start question --
-- #Comment=start question Comment --
ztaskGotoNoahsArk.Complete = true
Wherigo.GetInput(zinputHouse)
ztaskGotoStatue.Active = true
end

function zoneNoahsArk:OnProximity()
-- #GroupDescription=near to start --
-- #Comment=near to start Comment --
Wherigo.MessageBox{Text=[[You are nearly there, or you have just left the zone!]],}
end

function zinputStatue:OnGetInput(input)
Statue = concathex(input)
-- #GroupDescription=statue answer --
-- #Comment=statue answer Comment --
if   Wherigo.NoCaseEquals(Statue,"3631") then
Wherigo.PlayAudio(zmediaclapping)
Wherigo.MessageBox{Text=[[Correct, next stage follows]],Media=zmediaCorrect,}
zoneNailseaLocalFigure.Visible = false
zoneJacklandsFishFarm.Active = true
zoneJacklandsFishFarm.Visible = true
else
Wherigo.PlayAudio(zmediascream)
Wherigo.MessageBox{Text=[[No rubbish, try again]],Media=zmediaIncorrect,}
end
end

function zoneNailseaLocalFigure:OnEnter()
-- #GroupDescription=statue question --
-- #Comment=statue question Comment --
Wherigo.GetInput(zinputStatue)
ztaskGotoStatue.Complete = true
ztaskGotoFishFarm.Active = true
end

function zoneJacklandsFishFarm:OnEnter()
-- #GroupDescription=package --
-- #Comment=package Comment --
ztaskGotoFishFarm.Complete = true
Wherigo.GetInput(zinputfishyquestion)
ztaskGotothecamp.Active = true
end

function zinputfishyquestion:OnGetInput(input)
Trout = concathex(input)
-- #GroupDescription=fishy question --
-- #Comment=fishy question Comment --
if   Wherigo.NoCaseEquals(Trout,"3233") then
Wherigo.PlayAudio(zmediaclapping)
Wherigo.MessageBox{Text=[[Yes that is correct, move to the next zone!]],Media=zmediaCorrect,}
zoneJacklandsFishFarm.Visible = false
zoneCadburyCamp.Active = true
zoneCadburyCamp.Visible = true
else
Wherigo.PlayAudio(zmediascream)
Wherigo.MessageBox{Text=[[Nope, try adding up again!]],Media=zmediaIncorrect,}
end
end

function cartNailseaWander:OnStart()
-- #GroupDescription=start cartridge --
-- #Comment=start cartridge Comment --
Wherigo.PlayAudio(zmediaFanfare)
Wherigo.MessageBox{Media=zmediaintro,Buttons={"Next Instruction",},Callback=cartNailseaWander.MsgBoxCBFuncs.MsgBoxCB1}
end

function zinputchurch:OnGetInput(input)
Church = concathex(input)
-- #GroupDescription=camp question --
-- #Comment=camp question Comment --
if   Wherigo.NoCaseEquals(Church,"3537") then
Wherigo.PlayAudio(zmediaclapping)
Wherigo.MessageBox{Text=[[Yes correct now move to the final stage to find the cache.

Don't forget you need to enter the code word found in the front of the log book to complete the mission]],Media=zmediaCorrect,}
zoneTickenhamChurch.Visible = false
ztaskGotothecache.Active = true
zoneTheCache.Active = true
zoneTheCache.Visible = true
else
Wherigo.PlayAudio(zmediascream)
Wherigo.MessageBox{Text=[[No wrong, try again]],Media=zmediaIncorrect,}
end
end

function zoneTickenhamChurch:OnEnter()
-- #GroupDescription=church --
-- #Comment=church Comment --
ztaskGotothechurch.Complete = true
Wherigo.GetInput(zinputchurch)
ztaskGotothecache.Active = true
end

function zoneCadburyCamp:OnEnter()
-- #GroupDescription=cadbury camp entry --
-- #Comment=cadbury camp entry Comment --
ztaskGotothecamp.Complete = true
Wherigo.GetInput(zinputcamp)
ztaskGotothechurch.Active = true
end

function zinputcamp:OnGetInput(input)
Camp = concathex(input)
-- #GroupDescription=camp question --
-- #Comment=camp question Comment --
if   Wherigo.NoCaseEquals(Camp,"42413132365144") or Wherigo.NoCaseEquals(Camp,"424131321365144") then
Wherigo.PlayAudio(zmediaclapping)
Wherigo.MessageBox{Text=[[That is correct, on to the next zone]],Media=zmediaCorrect,}
zoneCadburyCamp.Visible = false
zoneTickenhamChurch.Visible = true
zoneTickenhamChurch.Active = true
else
Wherigo.PlayAudio(zmediascream)
Wherigo.MessageBox{Text=[[That is just plain wrong, don't forget to use CAPITAL letters!]],Media=zmediaIncorrect,}
end
end

function zoneTheCache:OnEnter()
-- #GroupDescription=final location --
-- #Comment=final location Comment --
ztaskGotothecache.Complete = true
Wherigo.GetInput(zinputcompletioncode)
end

function zinputcompletioncode:OnGetInput(input)
ccode = concathex(input)
-- #GroupDescription=completion code --
-- #Comment=completion code Comment --
if   Wherigo.NoCaseEquals(ccode,"53554e5345454b4552") then
Wherigo.PlayAudio(zmediaFanfare)
Wherigo.MessageBox{Text=[[Congratulations, you have completed the cache. To complete the cartidge and claim the find you need to unlock the cartridge by uploading the saved GWS file.
Many thanks for playing
Corporal Gore-tex.]],Media=zmediaCorrect,}
cartNailseaWander.Complete = true
else
Wherigo.PlayAudio(zmediascream)
Wherigo.MessageBox{Text=[[How could you fail at the final hurdle, have another go!]],Media=zmediaIncorrect,}
end
end
------End Builder Generated functions, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------
------Builder Generated callbacks, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------
--#LASTCALLBACKKEY=3#--
cartNailseaWander.MsgBoxCBFuncs.MsgBoxCB2 = function(action)
if action ~= nil then
-- #GroupDescription=The Clue --
-- #Comment=The Clue Comment --
Wherigo.MessageBox{Text=[[The Cache is Hidden under the bridge]],}
end
end

cartNailseaWander.MsgBoxCBFuncs.MsgBoxCB3 = function(action)
if action ~= nil then
-- #GroupDescription=clue --
-- #Comment=clue Comment --
Wherigo.MessageBox{Text=[[It is under the bridge]],}
end
end

cartNailseaWander.MsgBoxCBFuncs.MsgBoxCB1 = function(action)
if action ~= nil then
-- #GroupDescription=intro2 --
-- #Comment=intro2 Comment --
Wherigo.MessageBox{Media=zmediaintro2,Buttons={"Click To Move On",},}
end
end

------End Builder Generated callbacks, Do not Edit, this will be overwritten------
-- #Author Functions Go Here# --
function concathex (k)
  --k = string.lower(k)
  return (string.gsub(k, ".", function (c)
           return string.format("%02x", string.byte(c))
         end))
end
-- #End Author Functions# --
-- Nothing after this line --
return cartNailseaWander
